#ifndef __LISTE_H__
#define __LISTE_H__

#define      ELT_OK        -1
#define      END_OF_LIST   -2

#ifdef __BUILD_TOOLS_DLL
#define _EXPORT
#else
#define _EXPORT
#endif


// ------> definition du containaire liste



struct Link
 { Link *next,
        *previous;
   Link()  { next = previous = 0; };
   Link(Link *n) { next = n; previous = 0; };
   Link(Link *p,Link *n) { next = n; previous = p; };
   ~Link() {};
 };
class _EXPORT BaseList
 { Link     *premier,
				*courant,
				*dernier,
				*last_index;
	unsigned nbre_elt,
				last_acces;

   public :
   BaseList();
   ~BaseList();
   void purge();
   void insert(Link*);
   void append(Link*);
   void insertAt(Link*,unsigned);
   void initParcour(){ courant = premier; };
   Link *getNext();
	Link *getPrevious();
   unsigned nbreElt() { return nbre_elt; };
   Link *operator [](unsigned i);
   int removeAt(unsigned position);
 };
template <class T>
struct TLink : public Link
 { T       info;
	TLink(const  T& a) : info(a) { };
 };
template <class T>
class List : private BaseList
 { int          OwnsElements;
	public :
	List(int ownsElementsFlag = 1) : BaseList() { OwnsElements = ownsElementsFlag; }
	~List() { empty(); }
	void insertObject(const T& a) { BaseList::insert( new TLink<T>(a)); };
	void addObject(const T& a) { BaseList::append( new TLink<T>(a)); };
	void insertObjectAt(const T& a,unsigned p) { BaseList::insertAt (new TLink<T>(a),p); };
	int  removeObjectAt(unsigned position);
	void empty();
	void initIteration() { BaseList::initParcour(); };
	unsigned count () { return BaseList::nbreElt(); };
	int getNext(T & i);
	int getPrevious(T &i);
	T operator [](unsigned i);
	int ownsElements() { return OwnsElements; }
	void ownsElements(int aFlag) { OwnsElements = aFlag?1:0; }
 };
//     ---> List<T>::getNext()
//
// retourne le Prochaine elt d'une liste

template <class T>
int List<T>::getNext(T &i)
 { TLink<T> *l = (TLink<T>*) BaseList::getNext();
	if (l == 0)
		return END_OF_LIST;
	i = l->info;
	return ELT_OK;
 }
template <class T>
int List<T>::getPrevious(T &i)
 { TLink<T> *l = (TLink<T>*) BaseList::getPrevious();
	if (l == 0)
		return END_OF_LIST;
	i = l->info;
	return ELT_OK;
 }
template <class T>
T List<T>::operator [](unsigned i)
 { TLink<T> *l = (TLink<T>*) BaseList::operator[](i);
	T        inf;

	if (l != 0)
		inf = l->info;
	return inf;
 }
template <class T>
int List<T>::removeObjectAt(unsigned position)
 { TLink<T> *l = (TLink<T>*) BaseList::operator[](position);

	if (l != 0 && OwnsElements)
		delete l->info;
	return BaseList::removeAt(position);
 }

template <class T>
void List<T>::empty()
 { if (OwnsElements)
		for (int i=0;i<nbreElt();i++)
			if ((*this)[i])
				delete (*this)[i];
	BaseList::purge();
 }

// -----> Definition de la classe SortedList
//
// SE :
template <class T>
class SortedList : protected List<T>
 { public:
   SortedList(int ownsElementsFlag = 1);
	int addObject(const T& anObject);
   int  removeObjectAt(unsigned position) { return List<T>::removeObjectAt(position); }
	T operator [](unsigned i) { return List<T>::operator[](i); }
	int ownsElements() { return List<T>::ownsElements(); }
	void ownsElements(int aFlag) { List<T>::ownsElements(aFlag); }
   int count() { return List<T>::count(); }
 };
template <class T>
SortedList<T>::SortedList(int ownsElementFlag) : List<T>(ownsElementFlag)
 {
 }
template <class T>
int SortedList<T>::addObject(const T& anObject)
 { int		i;
   for (i = 0;i < count() && *anObject > *(operator[](i));i++);
   	insertObjectAt(anObject,i);
   return i;
 }

 #endif
